<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Manage Filtering Options</h1>
<p>
<a href="<%=response.encodeURL("FrontController?operation=509") %>">Back Home</a>
</p>

<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>

<%
UserBean user = (UserBean)request.getAttribute("user");

String reportReceiver;
String restrictToBuddy = "";
String crEnabled = "";
String addOutboundRecipientsToWhiteList = "";
String allowUserToAssociate = "";
String forcePwdChange = "";
String strictLocal = "";
String notify;

if(user == null){
    reportReceiver = "";
    notify = " checked ";
}else{
 	restrictToBuddy = user.isRestrictIncomingToFriendsOnly() ? " checked " : "";
 	addOutboundRecipientsToWhiteList = user.isAddOutboundRecipientsToWhiteList() ? " checked " : "";
	reportReceiver = user.getReportReceiver() == null ? "" : user.getReportReceiver();
	crEnabled = user.isChallengeResponseEnabled() ? " checked " : "";
	notify = user.isNotify() ? " checked " : "";
}

%>



<!-- ******* Divide Page into Two Columns, Total Widths must Equal 12 (or less) ******* -->
<div class="row">
	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Options</div>
			<div class="well-info-body">
			
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('crEnabled')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-8">Challenge-Response</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="chk-crEnabled" type="checkbox" name="crEnabled" <%=crEnabled%>>
						<label for="chk-crEnabled"></label>
					</span>
			
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="crEnabled">
						Enables challenge-response for this user. In this case, inbound emails are only accepted after the original sender verifies a challenge, indicating 
						they are real humans and not a bot.
					</div>
					
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('restrictInbound')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-8">Restrict inbound emails to whitelisted senders</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="chk-restrict" type="checkbox" name="chkRestrictToBuddy" <%=restrictToBuddy%>>
						<label for="chk-restrict"></label>
					</span>
			
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="restrictInbound">
						Every in-bound message will be marked as junk unless the sender's email address is explicitly whitelisted. 
						<br><br>There are three ways to whitelist senders:
						<ol>
							<li>The users logs in to admin console using his/her credentials and adds an email</li>
							<li>The users moves an email from junk folder to good folder using an IMAP client such as MS Outlook. This option
							is NOT available when running in <b>firewall</b> mode.</li>
							<li>The box displayed below is checked and the user sends an out-bound email to a recipient on the Internet</li> 
						</ol>
					</div>
					
					
					
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('notifyMsg')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-8">Send Quarantine Report</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="chk-notMsg" type="checkbox" name="chkNotify" <%=notify%>>
						<label for="chk-notMsg"></label>
					</span>
			
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="notifyMsg">
						If checked, a summary of every email that was blocked by the server will be sent to the user around midnight every day.
						You will have the ability to restore any incorrectly blocked message using this report.
					</div>
			
					<h3 class="text-center">Report times:</h3>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('notifyTime')"><b>?</b></div>
						<div class="form-control form-right pull-left wth-9">
						<%
						if(user == null){
							out.println(ResourceBean.generateHTMLSelectOptionsForReportTimes("reportTime_", true));
						}else{
							out.println(user.generateHTMLSelectOptionsForReportTimes("reportTime_", true));
						}
			
						%>
						</div>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="notifyTime">
						Time of the day when quarantine reports are sent. These timings have no affect if <b>Send notification messages</b> is not 
						checked.<br><br>
						
						Reports generated at midnight will contain data for the previous day. Reports for any other time will contain data since midnight
						for the current day.
					</div>
		
		
		
		
				
					<br style="clear:both;"><br>
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					
					<br><br>
					
					<input type="hidden" name="operation" value="udfr">
					<input type="hidden" name="st" value="s"> 
					
					
				</form>
			</div>
		</div>
	</div>
	
	<div class="col-md-6">
		<a href="<%=response.encodeURL("FrontController?operation=103") %>"><button class="btn btn-default">Manage White/Black list</button></a>
		<a href="<%=response.encodeURL("FrontController?operation=mlnss") %>"><button class="btn btn-default">Newsletter Subscriptions</button></a>
	</div>
</div>

	




 
  
  





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
