<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<%
UserBean currentUser = (UserBean)request.getAttribute("currentUser");
UserFilter currentFilter = (UserFilter)request.getAttribute("currentFilter");

if(currentUser == null){
	out.println("User not available");
	return;
}

String filterName = "";
int totalRuleCount = 0;
int totalActionCount = 0;

if(currentFilter != null){
	filterName = currentFilter.getFilterName();
	totalRuleCount = currentFilter.getRules().size();
	totalActionCount = currentFilter.getActions().size();
}
%>

<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=500") %>">User Administration</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=527") %>&id=<%=currentUser.getEmail() %>">User Administration</a>

<h1>Rules Editor for "<%=filterName %>" Filter &nbsp; <small>&lt;<%=currentUser.getEmail() %>&gt;</small></h1>
<br>
<div class="well">
	Every user filter consists of:		
	<ul>
		<li>A set of rules that are used for searching</li>
		<li>A set of actions that are performed when a match is found</li>
	</ul>
</div>
<!-- 
<p>
<table width="100%">
	<tr>
		<td><input type="radio" name="matchType" value="<%=UserFilter.MT_MATCH_ALL %>">Match all of the following</td>
		<td><input type="radio" name="matchType" value="<%=UserFilter.MT_MATCH_ANY %>" checked="checked" >Match any of the following</td><td></td>
	</tr>
</table>
</p> -->
    

<button class="btn btn-sm btn-submit pull-left" onClick="return overlay(this, 'newRuleForm')">New Rule</button><span class="pull-left">&nbsp;&nbsp;</span>
<button class="btn btn-sm btn-submit pull-left" onClick="return overlay(this, 'newActionForm')">New Action</button>

<form action="<%= request.getAttribute("appPath") %>" method="post">
<button class="btn btn-sm btn-menu pull-right" type="submit">&nbsp; Close &nbsp;</button>
<input type="hidden" name="operation" value="527" />
<input type="hidden" name="id" value="<%= request.getParameter("id") %>" />
</form>
<br style="clear:both;">

<!--Do not remove outer most DIV tag with id="newRuleForm"-->
<DIV id="newRuleForm" style="position:absolute; border: 2px solid #A0370D; background-color: white; width: 400px; padding: 8px; display:none; z-index:5;">

    <b>Enter a new Filter Rule</b><br>
    <form action="<%= request.getAttribute("appPath") %>" method="post" id="topform">
		<select class="form-control form-left pull-left wth-3" name="fieldName">
			<option value="5"><%=UserFilterRule.getFieldNameFromId(5) %></option>
			<option value="4"><%=UserFilterRule.getFieldNameFromId(4) %></option>
			<option value="1"><%=UserFilterRule.getFieldNameFromId(1) %></option>
			<option value="2"><%=UserFilterRule.getFieldNameFromId(2) %></option>
			<option value="3"><%=UserFilterRule.getFieldNameFromId(3) %></option>
			<option value="8"><%=UserFilterRule.getFieldNameFromId(8) %></option>
			<option value="7"><%=UserFilterRule.getFieldNameFromId(7) %></option>
			<option value="9"><%=UserFilterRule.getFieldNameFromId(9) %></option>		
			<!-- 
			
			<option value="10"><%=UserFilterRule.getFieldNameFromId(10) %></option>	
			<option value="11"><%=UserFilterRule.getFieldNameFromId(11) %></option>	
			<option value="12"><%=UserFilterRule.getFieldNameFromId(12) %></option>		
			-->	
		</select>
		<select class="form-control form-middle pull-left wth-3" name="oppName">
			<option value="<%=UserFilterRule.OPP_CONTAINS%>"><%=UserFilterRule.OPP_CONTAINS%></option>
			<option value="<%=UserFilterRule.OPP_IS%>"><%=UserFilterRule.OPP_IS%></option>				
			<option value="<%=UserFilterRule.OPP_GREATER_THAN%>"><%=UserFilterRule.OPP_GREATER_THAN%></option>
			<option value="<%=UserFilterRule.OPP_LESS_THAN%>"><%=UserFilterRule.OPP_LESS_THAN%></option>
			<option value="<%=UserFilterRule.OPP_STARTS_WITH%>"><%=UserFilterRule.OPP_STARTS_WITH%></option>
			<option value="<%=UserFilterRule.OPP_ENDS_WITH%>"><%=UserFilterRule.OPP_ENDS_WITH%></option>
			<option value="<%=UserFilterRule.OPP_ANY_VALUE%>"><%=UserFilterRule.OPP_ANY_VALUE%></option>
		</select>
		<input class="form-control form-right pull-left wth-4" type="text" name="ruleValue" size="25" >
    	<input type="hidden" name="id" value="<%=currentUser.getEmail() %>">
		<input type="hidden" name="operation" value="530">
		<input type="hidden" name="filterName" value="<%=filterName %>">        
		<input type="hidden" name="saveType" value="addRule">
		<br style="clear:both";>
        <button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
        <input class="btn btn-sm btn-menu" value="Cancel" type="button" onClick="overlayclose('newRuleForm'); return false" />
    </form>
</DIV>


<p>


<div class="row">
	<%
	if(totalRuleCount > 0){
	%>
	<div class="col-md-6">
		<h3 class="text-center">List of existing Rules</h3>
		<div class="well-info-wrap">
			<table class="table table-striped table-bordered table-hover">

				<tr class="well-info-header">
					<th>Seq #</th>
					<th>Field Name</th>
					<th>Operator</th>
					<th>Search String</th>
					<th>Tasks</th>
				</tr>
				<%
				if(currentFilter != null){
					
					
					for(int i = 0; i < currentFilter.getRules().size(); i++){
						UserFilterRule oneRule = (UserFilterRule)currentFilter.getRules().get(i);
						
					%>
						<tr><td><%=(i + 1) %></td>
							<td><%=UserFilterRule.getFieldNameFromId(oneRule.getFieldName()) %></td>
							<td><%=oneRule.getOperator() %></td>
							<td><%=oneRule.getSearchStr() %></td>
							<td>
							  <a href="<%=response.encodeURL("FrontController?operation=531") %>&idx=<%=i %>&type=rule&id=<%=currentUser.getEmail() %>&filterName=<%=currentFilter.getFilterName() %>" title="Delete this rule" >
								<img src="<%=imagePath %>delete16.gif" style="width:16px;height:16px;float:left;margin:2px 0px 0px 4px;border:0px;" />
							  </a>				  
							 </td>
						</tr>
					
					<%
					}
				}
				%>				
			</table>
		</div>
	</div>
	<%
	}
	if(totalActionCount > 0){
	%>	
	<div class="col-md-6">
		<h3 class="text-center">List of existing Actions</h3>
		<div class="well-info-wrap">
			<table class="table table-striped table-bordered table-hover">
		
				<tr class="well-info-header">
					<th>Seq #</th>
					<th>Action Type</th>
					<th>Action Value</th>
					<th>Tasks</th>
				</tr>
				

				<%
				if(currentFilter != null){
					for(int i = 0; i < currentFilter.getActions().size(); i++){
						UserFilterAction oneAction = (UserFilterAction)currentFilter.getActions().get(i);
						
					%>
						<tr>
							<td><%=(i + 1) %></td>
							<td><%=oneAction.getActionName() %></td>
							<td><%=oneAction.getActionOpp() %>
							<%= ((oneAction.getActionValue() == null) ? "" : oneAction.getActionValue())%></td>
							<td>
							  <a href="<%=response.encodeURL("FrontController?operation=531") %>&idx=<%=i %>&type=action&id=<%=currentUser.getEmail() %>&filterName=<%=currentFilter.getFilterName() %>" title="Delete this rule">
							  <img src="<%=imagePath %>delete16.gif" style="width:16px;height:16px;float:left;margin:2px 0px 0px 4px;border:0px;" />
							  </a>
							 </td>
						</tr>
					
					<%
					}
				}
				%>					
			</table>
		</div>
	</div>
	<%
	}
	%>
</div>


<script type="text/javascript">
	
function promptForNewFolder(){
	var comboValue = document.getElementById("actionOppCombo");
	
	if(comboValue.value == "--newFolder--"){
		overlay(comboValue, 'newFolder');
	}
}

function addNewFolder(){
	var vNewFolderName = document.newFolderForm.newFolderName.value; //document.getElementById("newFolderName");
	var vParentFolderName = document.newFolderForm.parentFolder.value;
	
	
	var opt = document.createElement('option');
	opt.text = vParentFolderName + '/' + vNewFolderName;
	opt.selected = true;
	
	
	
	var cmb = document.getElementById("actionOppCombo");
	
	try{
		cmb.add(opt, null);
	}catch(ex){
		cmb.add(opt);
	}
	
	overlayclose('newFolder');
	
	
}




function showHideOptionText(){
	var selectedValue = document.getElementById("actionNameId").value;
	var optionComboBox = document.getElementById("actionOppCombo");
	var optionTextBox = document.getElementById("actionTextId");
	
	if(selectedValue == '<%=UserFilterAction.ACN_FORWARD_TO%>'){
		optionComboBox.style.display = 'none';
		optionTextBox.style.display = 'inline';
	}else if (selectedValue == '<%=UserFilterAction.ACN_DELETE%>'){
		optionComboBox.style.display = 'none';
		optionTextBox.style.display = 'none';
	}else{
		optionComboBox.style.display = 'inline';
		optionTextBox.style.display = 'none';
	}
}


</script>



<!--Do not remove outer most DIV tag with id="newRuleForm"-->
<DIV id="newActionForm" style="position:absolute; border: 2px solid #A0370D; background-color: white; width: 400px; padding: 8px; display:none">

    <b>Enter a new Filter Action</b><br>
    <form action="<%= request.getAttribute("appPath") %>" method="post" id="topform">
		<select class="form-control form-left pull-left wth-5" name="actionName" onclick="showHideOptionText();" id="actionNameId">		
			<option value="<%=UserFilterAction.ACN_MOVE_TO%>"><%=UserFilterAction.ACN_MOVE_TO%></option>
			<option value="<%=UserFilterAction.ACN_FORWARD_TO%>"><%=UserFilterAction.ACN_FORWARD_TO%></option>	
			<option value="<%=UserFilterAction.ACN_DELETE%>"><%=UserFilterAction.ACN_DELETE%></option>			
		</select>
		<select class="form-control form-right pull-left wth-5" name="actionOpp" onclick="promptForNewFolder();" id="actionOppCombo">
			<%
				List<String> folders = currentUser.getFolderMailboxNames();
			
				for(int i = 0; i < folders.size(); i++){
					String oneFolder = folders.get(i).toString();
					out.println("<option value='" + oneFolder + "'>" + oneFolder + "</option>");
				}
			%>
			
			<option value='--newFolder--'>--Create New Folder--</option>
		</select>
		<input class="form-control form-right pull-left wth-5" type='text' name='actionText' id='actionTextId' value="" placeholder="Email Address">
    	<input type="hidden" name="id" value="<%=currentUser.getEmail() %>">
		<input type="hidden" name="operation" value="530">        
		<input type="hidden" name="saveType" value="addAction"> 
		<input type="hidden" name="filterName" value="<%=filterName %>"> 
		<br style="clear:both";>
        <button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
        <input class="btn btn-sm btn-menu" value="Cancel" type="button" onClick="overlayclose('newActionForm'); return false" />
    </form>
</DIV>






<!--Do not remove outer most DIV tag with id="newRuleForm"-->
<DIV id="newFolder" style="position:absolute; border: 2px solid #A0370D; background-color: white; width: 400px; padding: 8px; display:none; z-index:5;">

    <p><b>Select a parent folder and specify a new folder name.</b><br>
    <form method="post" action="#" name="newFolderForm">
    
    	<table>
    		<tr>
				
				<td><select name="parentFolder" id="parentFolderId">
						<%
							for(int i = 0; i < folders.size(); i++){
								String oneFolder = folders.get(i).toString();
								out.println("<option value='" + oneFolder + "'>" + oneFolder + "</option>");
							}
						%>
					</select> 	 
				</td>
					
				<td>
					<input type="text" name="newFolderName" value="" /> 	
				</td>
			</tr>
    	</table>
    	<input value="Ok" type="button" onClick="addNewFolder(); return false" />
        <input value="Cancel" type="button" onClick="overlayclose('newFolder'); return false" />
    </form>
    
    </p>
</DIV>

<script type="text/javascript">
showHideOptionText();
</script>

</td></tr></table>
	 </td>
    <%@ include file="InnerRightGrey.jsp" %>
	</tr>
</table>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>

