<%@ page import="java.util.*, com.synametrics.xeams.bean.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=500") %>">User Administration</a> &raquo;
User Filters

<%
	UserBean currentUser = (UserBean)request.getAttribute("currentUser");

	if(currentUser == null){
		out.println("Invalid user specified");
		return;
	}

%>

<h1>User Filters &nbsp; <small>&lt;<%=currentUser.getEmail() %>&gt;</small></h1>
<br>
<%
	
	
	int existingRuleCount = currentUser.getUserFilters().size();
	
	if(existingRuleCount == 0){
		out.println("<div class=\"alert alert-danger text-center\">There are no filters defined yet.</div>");
	}else{
		
%>

	<table class="table table-striped table-bordered">
		<tr class="well-info-header">
			<th class="text-center">Filter Name</th>
			<th class="text-center">Action</th>
		</tr>
		
		<%
		
		boolean atLeastOneAvailable = false;
		for(int i = 0; i < existingRuleCount; i++){
			
			atLeastOneAvailable = true;
			UserFilter oneRule = (UserFilter)currentUser.getUserFilters().get(i);
			oneRule.getFilterName();
			oneRule.isEnabled();
			
			out.println("<tr>");
			out.println("<td><a href='FrontController?operation=529&filterName=" + oneRule.getFilterNameForWeb() +
					"&id=" + currentUser.getEmail()+ "'>" + oneRule.getFilterName() + "</a></td>");
			
			//Delete button
			out.println("<td class=\"text-center\"><a href='FrontController?operation=531&idx=" + i + "&type=filter&id=" + currentUser.getEmail() + "' title='Delete this rule' >" +
					"<i class='glyphicon glyphicon-remove'></i> Delete</a> | ");
			
			//Edit button
			out.println("<a href='FrontController?operation=529&filterName=" + oneRule.getFilterNameForWeb() + "&id=" + currentUser.getEmail() + "' title='Modify rule' >" +
					"<i class='glyphicon glyphicon-pencil'></i> Edit</a> | ");
			
			
			out.println("<a href='FrontController?operation=532&idx=" + i + "&type=up&id=" + currentUser.getEmail() + "' title='Move up the rule' > " +
					"<i class='glyphicon glyphicon-arrow-up'></i> Move Up</a> | ");
			
			out.println("<a href='FrontController?operation=532&idx=" + i + "&type=down&id=" + currentUser.getEmail() + "' title='Move down the rule' >" +
					"<i class='glyphicon glyphicon-arrow-down'></i> Move Down</a> </td>");
			
			
			out.println("</tr>");
		}
		
		
		if(!atLeastOneAvailable){
			out.println("<tr>");
			out.println("<td colspan=2>No filter rules have been defined. Click <b>Add Filter</b> button to add one.</td>");
			out.println("</tr>");
		}
		%>
	</table>
<%
	}	
%>

<button class="btn btn-sm btn-submit" type="submit" type="button" onClick="return overlay(this, 'newRuleForm')" title="Click here to add a new rule.">Add Filter</button>		
	
<!--Do not remove outer most DIV tag with id="newRuleForm"-->
<DIV id="newRuleForm" style="position:absolute; border: 2px solid #A0370D; background-color: white; width: 400px; padding: 8px; display:none">

    <form action="<%= request.getAttribute("appPath") %>" method="post" id="topform">
    
    	<table>
    		<tr>
				<td>New Filter Name:</td>
				<td><input type="text" name="filterName" size="25" ></td>		
			</tr>
    	</table>
    	<input type="hidden" name="id" value="<%=currentUser.getEmail() %>">
		<input type="hidden" name="operation" value="530">        
		<input type="hidden" name="saveType" value="addFilterOnly"> 
		<input type="hidden" name="matchType" value="<%=UserFilter.MT_MATCH_ALL %>">
        <input value="Save"  type="submit" />
        <input value="Cancel" type="button" onClick="overlayclose('newRuleForm'); return false" />
    </form>
    
    </p>
</DIV>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
