<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
User Administration

<h1>User Administration</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>


<style>
	input[type=checkbox]{
		visibility:visible;
	}
</style>



<%
String msg = (String)request.getAttribute("Message");
if(msg != null) out.write("<div class=\"alert alert-info text-center\">" + msg + "</div>");


List<UserBean> users = (List<UserBean>)request.getAttribute("users");
int currentProfile = Integer.parseInt( (String)request.getAttribute("profileId"));
int authLevel = Integer.parseInt( (String) request.getAttribute("authorizationLevel"));

int activeUsers = Integer.parseInt( (String)request.getAttribute("activeUsers"));
int notificationUsers = Integer.parseInt( (String)request.getAttribute("notificationUsers"));
int totalUsers = Integer.parseInt( (String)request.getAttribute("totalUsers"));


%>

<br style="clear:both;">
<a href="<%=response.encodeURL("FrontController?operation=501") %>"><button class="btn btn-sm btn-menu pull-left"><span class="glyphicon glyphicon-plus"></span> &nbsp; New User</button></a>
<span class="pull-left">&nbsp; &nbsp;</span>

<span class="pull-right">

<%
if(authLevel >= ResourceBean.AL_SUPER_USER){
%>
	<a href="<%=response.encodeURL("FrontController?operation=212") %>"><button class="btn btn-sm btn-menu"><span class="glyphicon glyphicon-import"></span> &nbsp; Import Users</button></a>
	<a href="<%=response.encodeURL("FrontController?operation=202") %>"><button class="btn btn-sm btn-menu"><span class="glyphicon glyphicon-fire"></span> &nbsp; New User Wizard</button></a>
<%
}
%>
</span>

<br style="clear:both;"><br>
<%
String pageNumber = (String) request.getAttribute("cpn");
if(pageNumber == null){
	pageNumber = "1";	
}

%>
<br style="clear:both;"><br>
<div class="well-info-additional" style="border:solid 1px #aaa; border-bottom:none;">
	<div class="row">
		<div class="col-md-2">
			<%
			if(request.getAttribute("haspp") != null){
				%>
				<a href="<%= response.encodeURL("FrontController?operation=500&pn=" + request.getAttribute("haspp")) %>" title="Previous Page"><button class="btn btn-submit">Previous</button></a>
				<%
			}
			%>
		</div>
		<div class="col-md-4">
			Displaying page <b><%=pageNumber %></b> of <b><%= request.getAttribute("tp") %></b>
			
		</div>
		
		<div class="col-md-4">
			<form class="form-inline pull-right"  action="<%= request.getAttribute("appPath") %>" method="post" >
			
			  <div class="form-group">
			    <label class="sr-only" for="stxt">Filter</label>
			    <div class="input-group">
			      <div class="input-group-addon"><i class="glyphicon glyphicon-search" title="Search"></i></div>
			      <input type="text" class="form-control" id="stxt" placeholder="Search" name="stxt" title="Hit the ENTER key when done"
			      <%
			      if(request.getSession().getAttribute("User.Search.Text") != null){
			    	  %>
			    	  value="<%= request.getSession().getAttribute("User.Search.Text") %>"
			    	  <%
			      }
			      %>
			      
			      >
			      <!-- <div class="input-group-addon">.00</div> -->
			    </div>
			    
			    
			  </div>
			  
			  <div class="form-group checkbox">
					<input id="mycheck" class="normalcheck" type="checkbox" name="sa" value="1" checked='checked'> &nbsp;Search Associations
			  </div> 
			  
			  
			<input type="hidden" name="operation" value="500"> 
			</form>
		</div>
		<div class="col-md-2">
		<%
			if(request.getAttribute("hasnp") != null){
				%>
				<span class="pull-right">
				<a href="<%= response.encodeURL("FrontController?operation=500&pn=" + request.getAttribute("hasnp")) %>" title="Next Page"><button class="btn btn-submit">Next</button></a>
				</span>
				<%
			}
			%>
		</div>
	</div>

    <br style="clear:both;">

	Total Users: <span class="badge">&nbsp; <%=totalUsers%> &nbsp;</span><span class="menu_hide_sm hide_md"> &nbsp; &nbsp; | &nbsp; &nbsp; </span><br class="hide_lg">
	Number of active users: <span class="badge">&nbsp; <%=activeUsers%> &nbsp;</span><span class="menu_hide_sm hide_md"> &nbsp; &nbsp; | &nbsp; &nbsp; </span><br class="hide_lg">
	Users who will receive email notifications: <span class="badge">&nbsp; <%=notificationUsers%> &nbsp;</span><span class="menu_hide_sm hide_md"> &nbsp; &nbsp; | &nbsp; &nbsp; </span><br class="hide_lg"><br class="hide_lg">
	<a href="<%=response.encodeURL("FrontController?operation=179") %>"><button class="btn btn-xs btn-success"><span class="glyphicon glyphicon-dashboard"></span> &nbsp; Modify Report Schedule</button></a>
</div>

<div class="well-info-wrap">
	<div class="well-info-body no-padding table-responsive">
		
		<table class="table table-striped table-bordered table-hover">
		<tr class="well-info-header">
			<th>Login Id/Email</th>
			<th>Status</th>
			
			<%
			if(ResourceBean.isStandaloneOrHybrid()){
				%>
				<th>Disk Usage</th>
				<%
			}
			%>
			<th><acronym title="Emails sent/received since midnight">Emails <small>(received/sent)</small></acronym></th>
			<th><acronym title="Two-Factor Authentication">2FA</small></acronym></th>
			<th>Action</th>
		</tr>
		
		<%
		if(users.size() == 0){
		%>
		<h3>No users exist</h3>
		<%
		}


		for(int i = 0; i < users.size(); i++){

			UserBean oneUser = users.get(i);
	
			if(authLevel < ResourceBean.AL_ADMIN_USER){
				String userEmail = oneUser.getEmail();
	
				if(ResourceBean.getProfileId(userEmail) != currentProfile){
					continue;  //Continue the for loop
				}
	
			} 
			String reportTitle;
			if(oneUser.getLastNotificationDate() > 100){
				reportTitle = "Send Summary Report. Last sent on: " + GlobalFuncs.formatDate(oneUser.getLastNotificationDate());
			}else{
				reportTitle = "Send Summary Report.";
			}


		%>
		
		<tr>
		<td><a href="<%=response.encodeURL("FrontController?operation=217&u=" + oneUser.getEmailWebSafe()) %>" title="Click to login as <%=oneUser.getEmail()%>">
		<i class="glyphicon glyphicon-user"></i> <%=oneUser.getEmail()%></a>
		
		<%
			if(oneUser.isMidnightReportMissing()){
				%>
				<i class="glyphicon glyphicon-warning-sign" title="Midnight report missing. Click Edit to fix"> </i>
				<%
			}
		%>
			
		
		<%
			if(oneUser.isStrictLocal()){
				%>
				<span class="pull-right badge">Strict Local</span>
				<%
			}
			if(oneUser.isFromAD()){
				%>
				<span class="pull-right badge">LDAP</span>
				<%
			}
		%>
		</td>
		<td><%
		if(oneUser.isActive()){
			%>
			<i class="glyphicon glyphicon-thumbs-up"></i> Active
			<%
		}else{
			%>
			<i class="glyphicon glyphicon-thumbs-down"></i> <s>Inactive</s>
			<%
		}
		
		%></td>
		
		<%
			if(ResourceBean.isStandaloneOrHybrid()){
				%>
				<td><%= oneUser.getDiskUsageStr() %></td>
				<%
			}
			%>
			
		
		<td>
			<%
			UserEmailCount uec = oneUser.getEmailCountSinceMidnight();
			%>
			<%=uec.getTotalInbound() %> / <%=uec.getOutboundCount() %>
		</td>
		
		<td>
		<% 
			int tfaState = oneUser.getTFAState();
			if(tfaState <= 1 || tfaState > 3){
				%><span style="color:#DDDDDD;"><i class="glyphicon glyphicon-subscript" title="2FA is disabled"> </i> Disabled</span><%
			}else if(tfaState == 2){
				%><a href="<%= response.encodeURL("FrontController?operation=2fa&st=td&lenc=" + oneUser.getEmailWebSafe())%>" title="Click to temporarily disable 2FA for <%= oneUser.getEmail() %>"><span style="color:#8ab68c;"><i class="glyphicon glyphicon-subscript" title="2FA is enabled, click to disable it temporarily">  </i> Enabled</span></a><%
			}else{
				%><span style="color:#f09732;"><i class="glyphicon glyphicon-subscript" title="2FA is temporarily disabled" >  </i> Temporarily disabled</span><%
			}
		%>
		</td>
		
		
		<td><a href="<%=response.encodeURL("FrontController?operation=111") %>&emailAddress=<%=oneUser.getEmailWebSafe()%>" title="Associate multiple email addresses to this account"><i class="glyphicon glyphicon-pushpin"></i> Associations</a> |
			<a href="<%=response.encodeURL("FrontController?operation=100") %>&email=<%=oneUser.getEmailWebSafe()%>" title="<%=reportTitle%>"><i class="glyphicon glyphicon-stats"></i> Report</a> |
			
			<%if(ResourceBean.isStandaloneOrHybrid()){ %>
			<!-- Filtering is only applicable for Stand Alone or Hybrid types -->
			<a href="<%=response.encodeURL("FrontController?operation=527") %>&id=<%=oneUser.getEmailWebSafe()%>" title="Create folder filters"><i class="glyphicon glyphicon-filter"></i> Filters</a> |
			<%
			}
			%>
			<a href="<%=response.encodeURL("FrontController?operation=502") %>&id=<%=oneUser.getEmailWebSafe()%>" title="Modify settings"><i class="glyphicon glyphicon-pencil"></i> Edit</a> |
			<a href="<%=response.encodeURL("FrontController?operation=503") %>&id=<%=oneUser.getEmailWebSafe()%>" title="Delete this user account"><i class="glyphicon glyphicon-trash"></i> Delete</a></td>
		</tr>
		<%

		}
		%>

		</table>
	</div>
</div>

<br style="clear:both;">
<a href="<%=response.encodeURL("FrontController?operation=501") %>"><button class="btn btn-sm btn-menu"><span class="glyphicon glyphicon-plus"></span> &nbsp New User</button></a>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
