<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Missed Email Alerts</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}


List<MeaHolderBean> holders = (List<MeaHolderBean>) request.getAttribute("holders");

if(holders == null || holders.size() == 0){
	%>
	
	
	
	<div class="row">
		<div class="col-md-6 col-md-offset-3">
			<div class="well-info-wrap">
				<div class="well-info-header">Missed Email Alerts</div>
				<div class="well-info-body">
	
					<h2>No Alerts Exist</h2>
					<p>
					You have not created any alerts yet. Imagine you get emails based on a schedule. For example, you run a backup job that starts 
					daily at 4 PM and runs for around 30 minutes. Upon completion, this backup job sends an email; therefore, you expect an email 
					to come in around 4:30 containing a backup report.</p>
					<p>The goal of setting up a <b>Missed Email Alert</b> is to generate an alert if an expected message does not arrive in your 
					Inbox within a predefined time frame.
					</p>
					
					<h2>Steps To Setup</h2>
					<p>
					<ul>
						
						<%
						if ( authorizationLevel == ResourceBean.AL_REGULAR_USER){
							%>
							<li>Search for a message by clicking <a href="<%=response.encodeURL("FrontController?operation=509") %>">Home/Main Menu</a>.</li>
							<%
						}else{
							%>
							<li>Search for a message using the <a href="<%=response.encodeURL("FrontController?operation=22") %>">Message Repository</a>.</li>
							<%
						}
						%>
						<li>Click the <b>Subject</b> of the message to open it.</li>
						<li>Click the <b>Add Alert</b> button to add a new alert.</li>
					</ul>
					</p>
					<p><br><br>
					<center>
						<a href="https://www.xeams.com/missed-email-alerts.htm" target="_blank" title="Click here to watch a video on this topic"><button class="btn btn-success">
							<i class="glyphicon glyphicon-facetime-video"> </i> Tutorial Video</button></a><br>
							Watch a video on this topic.
					</center>
					</p>
			</div>
			</div>
	
		</div>
	</div>
	<%
}else{
%>


<h2>Existing Alerts</h2>

<div class="table-responsive">
<table class="table table-bordered table-hover">
	<tr>
		<th>Friendly Name</th>
		<th>Recipient</th>
		<th>Sender</th>
		<th>Subject</th>
		<th>Frequency</th>
		<th>Next Expected Date</th>
		<th>Action</th>
	</tr>
	
	<%
	
	
	for(int i = 0; i < holders.size(); i++){
		MeaHolderBean holder = holders.get(i);
		
		%>
		<tr <%
		if(holder.getState() == 1){ //Active
			out.print("class='success'");
		}else if(holder.getState() == 2){ //Received
			out.print("class='info'");
		}else if(holder.getState() == 3){ //Missed
			out.print("class='danger'");
		}else if(holder.getWatchStartTime() < System.currentTimeMillis()){
			out.print("class='warning'");
		}
		
		%>>
		<td><%= holder.getFriendlyName() %></td>
		<td><%= holder.getRecipient() %></td>
		<td><%= holder.getSender() %></td>
		<td><%= holder.getSubject() %></td>
		<td><%= holder.getFrequencyStr() %></td>
		<td><%= holder.getStartEndTime() %></td>
		<td>
		
		<%
		if(request.getAttribute("displayEdits") == null){
		%>
		<a href="<%=response.encodeURL("FrontController?operation=amea&st=e&id=" + holder.getPk()) %>" title="Edit Alert"><i class="glyphicon glyphicon-pencil"></i> </a>
		<span class="pull-right">
		<a href="<%=response.encodeURL("FrontController?operation=amea&st=d&id=" + holder.getPk()) %>" title="Delete Alert"><i class="glyphicon glyphicon-trash"></i> </a>
		</span>
		<%
		}else{
			%>
			<span style="color: #CCCCCC"><i class="glyphicon glyphicon-pencil" title="You cannot modify this rule when running as a Slave"></i></span>
			<span class="pull-right" style="color: #CCCCCC">
			<i class="glyphicon glyphicon-trash" title="You cannot modify this rule when running as a Slave"></i>
			</span>
			<%
		}
		%>
		
		</td>
		
		</tr>
		<%
	}
	%>
</table>

</div>

<%
}
%>
<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
