<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Watchdog Configuration</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><h2>Error</h2><%=errorMsg %></div>
	<%
}

%>
<br>


<!-- ******* Divide Page into Two Columns, Total Widths must Equal 12 (or less) ******* -->
<div class="row">
	<div class="col-md-6">
		<h2>What is Watchdog?</h2>
		<p>
		Watchdog is a free service provided by Synametrics Technologies that can monitor your Xeams 
		and will generate alerts via email if it does not respond.</p>
		
		<h2>Important Notes</h2>
		<ul>
			<li>This service can only monitor port 25. Disable <b>Monitor SMTP</b> if you're using the SMTP server on a different port.</li>
			<li>HTTPS is preferred over HTTP.</li>
		</ul>
	</div>
	
	<div class="col-md-6">
		<div class="well-info-wrap">
		<div class="well-info-header">Configuration</div>
		<div class="well-info-body">
			<form action="<%= request.getAttribute("appPath") %>" method="post">


			<%
			
			
			if(request.getAttribute("avc") != null){
				
				
				
				%>
				<div class="well well-sm">
				
					<p>
					<% if(request.getAttribute("multinoti") == null){ %>
					A verification code has been sent to <code><%= request.getAttribute("nEmail") %></code>. Please enter that value below.
					<%
					}else{
					%>
					A verification code has been sent to multiple addresses you specified for <b>Notification Email</b>. Every address has 
					received a different 6-digit code. Add up all the codes and enter their sum below. For example, if you received 100000 in 
					the first email and 200000 for the second, enter 300000 below.
					<%
					}
					%>
					</p>
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('vc')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Verification Code</span>
					<input class="form-control form-right pull-left wth-5" type="number" name="otp" value="" required>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="vc">
						Enter the verification code sent to you via email.
					</div>
				</div>
				
				<input type="hidden" name="votp" value="1"> 
				<%
			}
			%>

			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('wdEnabled')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Watchdog Enabled</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-srv" type="checkbox" value="1" name="wdEnabled" <%= request.getAttribute("wdEnabled") %> ><label for="chk-srv"></label></span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="wdEnabled">
				If checked, Watchdog service will be enabled for this Xeams.
			</div>
			
			<!-- Checkbox -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('mSmtp')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Monitor SMTP</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-smtp" type="checkbox" value="1" name="mSmtp" <%= request.getAttribute("mSmtp") %>><label for="chk-smtp"></label></span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="mSmtp">
				If checked, SMTP port 25 will be monitored. 
			</div>
			
			
			
			<!-- Checkbox -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('mHttp')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Monitor HTTP</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-http" type="checkbox" value="1" name="mHttp" <%= request.getAttribute("mHttp") %>><label for="chk-http"></label></span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="mHttp">
				If checked, HTTP port will be monitored.
			</div>
			
			
			<!-- Checkbox -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('boundary')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Boundary Alerts</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-boundary" type="checkbox" value="1" name="boundary" <%= request.getAttribute("boundary") %>><label for="chk-boundary"></label></span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="boundary">
				<p>If checked, notification alerts are boundary-based. There are two types of alerts:</p>
				<ul>
					<li><b>Continuous - </b> You get an alert every 10 minutes until the server comes back up.</li>
					<li><b>Boundary - </b> You get one alert when the server does not respond and another one when it comes back up.</li>
				</ul>
				
			</div>
			
			
			
			
			<!-- Text Box for hostname -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('hostname')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">FQDN</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="fqdn" value="<%= request.getAttribute("fqdn") %>" required>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="hostname">
				Fully qualified hostname, which is used when checking HTTP server.
			</div>
			  
			  
			<%
			if(request.getAttribute("avc") != null){
				%>
				<input type="hidden" name="nEmail" value="<%= request.getAttribute("nEmail") %>">
				<%
			}else{
			%>
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('nEmail')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Notification Email</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="nEmail" value="<%= request.getAttribute("nEmail") %>" required >
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="nEmail">
					<p>Email address where notifications are sent. It is recommended you use an email address that is not local to this Xeams, such as @gmail.com, or @outlook.com. </p>
					<p>Many mobile providers allow email-to-text. For example, use the following addresses if you live in the United States:</p>
					<ul>
						<li>T-Mobile: 1XXXXXXXXXX@tmomail.net</li>
						<li>AT&amp;T: XXXXXXXXXX@txt.att.net</li>
						<li>Verizon: XXXXXXXXXX@vtext.com</li>
					</ul>
					<br>
					<p><b>Important:</b> You will be required to validate this email address on the next screen.</p>
				</div>
			<%} %>
			
			<br style="clear:both;">
			<div>
				<span class="pull-right">
				It takes a few second to enable Watchdog. <b>DO NOT</b> double-click. &nbsp;&nbsp;
				<button class="btn btn-sm btn-submit" type="submit">Submit</button>
				</span>
			</div>
			
			
			<input type="hidden" name="operation" value="wdc" >
			<input type="hidden" name="st" value="sv" >
			
			  
			<br style="clear:both;">
			</form>
		</div>
	</div>
	</div>
</div>


<%
List<WatchdogSummaryBean> summBeans = (List<WatchdogSummaryBean>) request.getAttribute("summBeans");

if(summBeans != null){
	%>
	
	<br><br>
	<div class="row">
		<div class="col-md-6">
			<a href="<%=response.encodeURL("FrontController?operation=wdc&st=smlt") %>" title="Simulates a failure, which results in generating notification email."><button class="btn btn-menu">Simulate Failure</button></a>
		</div>
		<div class="col-md-6">
			<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=wdc&st=lt") %>" title="Confirms the Watchdog service can communicate with your Xeams."><button class="btn btn-default">Live Test</button></a></span>
		</div>
	</div>
	<%
}

if(summBeans != null && summBeans.size() > 0){
	%>
	
	<h2>Watchdog Summary For Past 10 Days</h2>
	
	<table class="table table-bordered">
		<thead>
		<tr>
			<th>Friendly name</th>
			<th>Public IP</th>
			<th>Protocol</th>
			<th>First Ping</th>
			<th>Last Ping</th>
			<th>Avg. Response Time (ms)</th>
			<th>Success</th>
			<th>Soft Fail</th>
			<th>Fail</th>
		</tr>
		</thead>
		
		<%
		for(WatchdogSummaryBean bean : summBeans){
			
			%>
			<tr>
				<td><%= bean.getFriendlyName() %></td>
				<td><%= bean.getIpAddress() %></td>
				<td><%= bean.getSTypeStr() %></td>
				<td><%= bean.getFirstPingAsStr() %></td>
				<td><%= bean.getLastPingAsStr() %></td>
				<td><%= bean.getAvgResponseTime() %></td>
				<td><%= bean.getTotalPass() %></td>
				<td><%= bean.getTotalSoftFail() %></td>
				<td><%= bean.getTotalFail() %></td>
				
			</tr>
			
			<%
		}
		%>
	</table>
	<%
}
%>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
